// precompiled header, should always be the first include
//#include "precompiled.hh"

#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/SMT/SrcStates.h"

//#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#include "etrace_if.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clSrcStateFactory.cpp.trc.h"
#endif

namespace AudioStack { namespace SourceStateMachine
{


clSrcState * clSrcStateFactory::m_pclOn               = NULL;
clSrcState * clSrcStateFactory::m_pclOff              = NULL;
clSrcState * clSrcStateFactory::m_pclPause            = NULL;
clSrcState * clSrcStateFactory::m_pclRampUp           = NULL;
clSrcState * clSrcStateFactory::m_pclRampUpInit       = NULL;
clSrcState * clSrcStateFactory::m_pclRampUpRequesting = NULL;
clSrcState * clSrcStateFactory::m_pclRampDownToPause  = NULL;
clSrcState * clSrcStateFactory::m_pclRampDownToOff    = NULL;
clSrcState * clSrcStateFactory::m_pclWaitFor          = NULL;
clSrcState * clSrcStateFactory::m_pclSrcAvailableCheck_On    = NULL;
clSrcState * clSrcStateFactory::m_pclSrcAvailableCheck_Pause = NULL;

clSrcState * clSrcStateFactory::pclCreateOff()
{
   if (!m_pclOff)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateOff()"));
      m_pclOff = OSAL_NEW clSrcState_Off();
   }
   return m_pclOff;
}

clSrcState * clSrcStateFactory::pclCreatePause()
{
   if (!m_pclPause)
   {
      ETG_TRACE_USR4(("New Instance: pclCreatePause()"));
      m_pclPause = OSAL_NEW clSrcState_Pause();
   }
   return m_pclPause;
}

clSrcState * clSrcStateFactory::pclCreateRampUp()
{
   if (!m_pclRampUp)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateRampUp()"));
      m_pclRampUp = OSAL_NEW clSrcState_RampUp();
   }
   return m_pclRampUp;
}

clSrcState * clSrcStateFactory::pclCreateRampUpInit()
{
   if (!m_pclRampUpInit)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateRampUpInit()"));
      m_pclRampUpInit = OSAL_NEW clSrcState_RampUpInit();
   }
   return m_pclRampUpInit;
}

clSrcState * clSrcStateFactory::pclCreateRampUpRequesting()
{
   if (!m_pclRampUpRequesting)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateRampUpRequesting()"));
      m_pclRampUpRequesting = OSAL_NEW clSrcState_RampUpRequesting();
   }
   return m_pclRampUpRequesting;
}

clSrcState * clSrcStateFactory::pclCreateRampDownToPause()
{
   if (!m_pclRampDownToPause)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateRampDownToPause()"));
      m_pclRampDownToPause = OSAL_NEW clSrcState_RampDownToPause();
   }
   return m_pclRampDownToPause;
}

clSrcState * clSrcStateFactory::pclCreateRampDownToOff()
{
   if (!m_pclRampDownToOff)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateRampDownToOff()"));
      m_pclRampDownToOff = OSAL_NEW clSrcState_RampDownToOff();
   }
   return m_pclRampDownToOff;
}

clSrcState * clSrcStateFactory::pclCreateOn()
{
   if (!m_pclOn)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateOn()"));
      m_pclOn = OSAL_NEW clSrcState_On();
   }
   return m_pclOn;
}

clSrcState * clSrcStateFactory::pclCreateWaitFor()
{
   if (!m_pclWaitFor)
   {
      ETG_TRACE_USR4(("New Instance: pclCreateWaitFor()"));
     m_pclWaitFor = OSAL_NEW clSrcState_WaitFor();
   }
   return m_pclWaitFor;
}

clSrcState * clSrcStateFactory::pclCreateSrcAvailableCheck_Pause()
{
   if (!m_pclSrcAvailableCheck_Pause)
   {
     ETG_TRACE_USR4(("New Instance: pclCreateSrcAvailableCheck_Pause()"));
     clSrcState_SourceAvailableCheck* state = OSAL_NEW clSrcState_SourceAvailableCheck("SrcAvailCheck_Pause");
     if(state != NULL)
     {
     m_pclSrcAvailableCheck_Pause = static_cast<clSrcState * >(state);
     state->vSetTransition(clSrcState::Pause, pclCreateSrcAvailableCheck_Pause());
     state->vSetTransition(clSrcState::On, pclCreateSrcAvailableCheck_On());
     state->vSetTransition(clSrcState::SrcAvailabilityChg, pclCreateRampDownToPause());
     state->vSetTransition(clSrcState::Off, pclCreateOff());
     }
   }
   return m_pclSrcAvailableCheck_Pause;
}

clSrcState * clSrcStateFactory::pclCreateSrcAvailableCheck_On()
{
   if (!m_pclSrcAvailableCheck_On)
   {
     ETG_TRACE_USR4(("New Instance: pclCreateSrcAvailableCheck_On()"));
     clSrcState_SourceAvailableCheck* state = OSAL_NEW clSrcState_SourceAvailableCheck("SrcAvailCheck_On");
     if(state != NULL){
     m_pclSrcAvailableCheck_On = static_cast<clSrcState * >(state);
     state->vSetTransition(clSrcState::On, pclCreateSrcAvailableCheck_On());
     state->vSetTransition(clSrcState::Pause, pclCreateSrcAvailableCheck_Pause());
     state->vSetTransition(clSrcState::SrcAvailabilityChg, pclCreateRampUpInit());
     state->vSetTransition(clSrcState::Off, pclCreateOff());
     }
   }
   return m_pclSrcAvailableCheck_On;
}

}}//namespace



